package gov.va.med.mhv.bluebutton.transfer;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class StudyDTO implements Serializable {
	private static final long serialVersionUID = -5964074692854369548L;

	private Long id;
	
	private String stationNumber;
	
	private String procedureName;
	
	private String event;
	
	private long patientId;
	
	private String studyIdUrn;
	
	private long imageCount;
	
	private Date performedDatePrecise;
	
	private String performedDateImprecise;
	
	private FacilityInfoDTO facilityInfo;

	private StudyJobDTO studyJob;
	
	//NEW
	private Boolean reportOnly;  // if true then only phr radiology report; if false then both radiology report and cvix imaging
	private Boolean cvixOnly;
	
	private String reportText;
	
	private Long phrRadiologyId = 0l;
	
	public static String MILITARY_DATE_PATTERN1 = "dd MMM yyyy @ HH";
	public static String MILITARY_DATE_PATTERN2 = "mm";
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getProcedureName() {
		return procedureName;
	}

	public void setProcedureName(String procedureName) {
		this.procedureName = procedureName;
	}

	public String getEvent() {
		return event;
	}

	public void setEvent(String event) {
		this.event = event;
	}

	public long getPatientId() {
		return patientId;
	}

	public void setPatientId(long patientId) {
		this.patientId = patientId;
	}

	public String getStudyIdUrn() {
		return studyIdUrn;
	}

	public void setStudyIdUrn(String studyIdUrn) {
		this.studyIdUrn = studyIdUrn;
	}

	public long getImageCount() {
		return imageCount;
	}

	public void setImageCount(long imageCount) {
		this.imageCount = imageCount;
	}

	public Date getPerformedDatePrecise() {
		return performedDatePrecise;
	}

	public void setPerformedDatePrecise(Date performedDatePrecise) {
		this.performedDatePrecise = performedDatePrecise;
	}

	public String getPerformedDateImprecise() {
		return performedDateImprecise;
	}
	
	public String getPerformedDateStr() {
		String sentD = null;
		SimpleDateFormat sdf1 = new SimpleDateFormat(MILITARY_DATE_PATTERN1);
		sdf1.setTimeZone(TimeZone.getTimeZone("America/New_York"));
		SimpleDateFormat sdf2 = new SimpleDateFormat(MILITARY_DATE_PATTERN2);
		sdf2.setTimeZone(TimeZone.getTimeZone("America/New_York"));
		
		if (performedDatePrecise != null) {
			sentD = sdf1.format(performedDatePrecise) 
					+ "<span class=\"usa-sr-only\">:</span>"
					+ sdf2.format(performedDatePrecise);
		}
		return sentD;
	}

	public void setPerformedDateImprecise(String performedDateImprecise) {
		this.performedDateImprecise = performedDateImprecise;
	}

	public FacilityInfoDTO getFacilityInfo() {
		return facilityInfo;
	}
	
	public void setFacilityInfo(FacilityInfoDTO facilityInfo) {
		this.facilityInfo = facilityInfo;
	}

	public StudyJobDTO getStudyJob() {
		return studyJob;
	}

	public void setStudyJob(StudyJobDTO studyJob) {
		this.studyJob = studyJob;
	}

	public Long getPhrRadiologyId() {
		return phrRadiologyId;
	}

	public void setPhrRadiologyId(Long phrRadiologyId) {
		this.phrRadiologyId = phrRadiologyId;
	}

	public Boolean getReportOnly() {
		return reportOnly;
	}

	public void setReportOnly(Boolean reportOnly) {
		this.reportOnly = reportOnly;
	}

	public Boolean getCvixOnly() {
		return cvixOnly;
	}

	public void setCvixOnly(Boolean cvixOnly) {
		this.cvixOnly = cvixOnly;
	}

	public String getReportText() {
		return reportText;
	}

	public void setReportText(String reportText) {
		this.reportText = reportText;
	}

}
